# Bahas (macOS)

**Bahas** is a command-line search tool built for minimalism, focus, and speed. It brings clean, distraction-free web search to your terminal — perfect for learning, research, and low-bandwidth environments.

---

## ✅ Features

- 🌐 Search the web via SerpAPI from your terminal  
- 📖 Read content in a beautiful Markdown-style format  
- ⚙️ Quick config via `.env` or `bahas config`  
- 🚀 Lightweight & works even on slow networks

---

## 🛠️ Installation

### 1. Download the correct binary:
- For Apple Silicon (M1, M2, M3):  
  `bahas-darwin-arm64`

---

### 2. Make it executable:

```bash
chmod +x bahas-darwin-arm64   # or bahas-darwin-amd64
```
### 3. (Optional) Move to a global location:
```bash
sudo mv bahas-darwin-arm64 /usr/local/bin/bahas
```

### 🔑 API Key Setup
- Option 1: Use .env file
```bash
cp .env.example .env
Add your SerpAPI key:
SERPAPI_KEY=your-api-key-here
```
- Option 2: Use the built-in config command
```bash
bahas config your-api-key-here
This securely saves your key locally.
```

**Usage**
- Run a web search:
```bash
bahas search "how to center a div in CSS"
```

- Get help:
```bash
bahas help
```

### 💡 Who is this for?
- Developers who want distraction-free searching

- Learners on poor or slow internet connections

- Anyone who prefers terminal over browser tabs

❤️ Built with Go, by a dev who just wanted peace of mind.