# Bahas (Linux) 
Compatible for M1/M2/M3/M4 chips

**Bahas** is a command-line search tool designed for minimal, fast, and focused browsing experiences, even on limited connections.

## ✅ Features

- 🌐 Search the web via SerpAPI from your terminal  
- 📖 Read content in a beautiful Markdown-style format  
- ⚙️ Quick config via `.env` or `bahas config`  
- 🚀 Lightweight & works even on slow networks

---

## 🚀 Installation

1. Download `bahas-linux-arm64`.

2. Make it executable and place it in a directory:
    ```bash
    chmod +x bahas-linux-arm64
    sudo mv bahas-linux-arm64 /usr/local/bin/bahas
    ```

3. (Optional) Or place it in your home directory and add to PATH:
    ```bash
    mkdir -p ~/bin
    mv bahas-linux-arm64 ~/bin/bahas
    export PATH="$HOME/bin:$PATH"
    ```

4. **Set up your API key** using:
    ```bash
    bahas config <your-api-key>
    ```

   Or by editing `.env`:

   Create a `.env` file in the same folder:

   ```bash
   SERPAPI_KEY=your-api-key
    ```
5. **Usage**
    ```bash
    bahas search "linux tutorial"
    bahas help
    ```

### 💡 Who is this for?
- Developers who want distraction-free searching

- Learners on poor or slow internet connections

- Anyone who prefers terminal over browser tabs

❤️ Built with Go, by a dev who just wanted peace of mind.